package bussiness;

import java.util.ArrayList;
import data.Student;
import service.RepositorioAluno;

public class CadastrarAluno {
	
	private RepositorioAluno repAlunos;
	
	public CadastrarAluno(){
		repAlunos = new RepositorioAluno(new ArrayList<Student>());
	}
	
	public void insertStudent(Student s){
		if(repAlunos.existsStudent(s.getId()))
			throw new RuntimeException(); // Lana a exceo JExisteEstudanteException
		else{
			repAlunos.insertStudent(s);
		}
	}
	
	public void insertStudents(ArrayList<Student> students){
		for (Student student : students) {
			this.insertStudent(student);
		}
	}
	
	public void removeStudent(int id){
		if(!repAlunos.existsStudent(id))
			throw new RuntimeException(); //Lana a exceo NoExisteUsurioException
		else
			repAlunos.removeStudent(id);
	}
	
	public void updateStudent(Student s){
		if(!repAlunos.existsStudent(s.getId()))
			throw new RuntimeException(); // Lana a exceo NoExisteUsurioException
		else
			repAlunos.updateStudent(s);
	}
	
	public Student getStudent(int id){
		if(!repAlunos.existsStudent(id))
			throw new RuntimeException(); // Lana a exceo NoExisteUsurioException
		else
			return repAlunos.getStudent(id);
	}
	
	public ArrayList<Student> getStudents(ArrayList<Integer> studentsIds){
		ArrayList<Student> students = new ArrayList<Student>();
		for (int studentId : studentsIds) {
			students.add(repAlunos.getStudent(studentId));
		}
		
		return students;
	}
}
