package bussiness;

import java.util.ArrayList;
import service.RepositorioProfessor;
import data.Professor;

public class CadastrarProfessor {

	private RepositorioProfessor repProf;
	
	public CadastrarProfessor(){
		this.repProf = new RepositorioProfessor(new ArrayList<Professor>());
		
	}
	
	public void insertProfessor(Professor p){
		if(repProf.existsProfessor(p.getId()))
			throw new RuntimeException(); // Lana a exceo j existe professor
		else
			repProf.insertProfessor(p);
	}
	
	public void insertProfessors(ArrayList<Professor> professors){
		for (Professor professor : professors) {
			this.insertProfessor(professor);
		}
	}
	
	public void removeProfessor(int id){
		if(!repProf.existsProfessor(id))
			throw new RuntimeException(); //Lana a exceo NoExisteUsurioException
		else
			repProf.removeProfessor(id);
	}
	
	public void updateProfessor(Professor p){
		if(!repProf.existsProfessor(p.getId()))
			throw new RuntimeException(); // Lana a exceo NoExisteUsurioException
		else
			repProf.updateProfessor(p);
	}
	
	public Professor getProfessor(int id){
		if(!repProf.existsProfessor(id))
			throw new RuntimeException(); // Lana a exceo NoExisteUsurioException
		else
			return repProf.getProfessor(id);
	}
	
	public ArrayList<Professor> getProfessors(ArrayList<Integer> professorIds){
		ArrayList<Professor> professors = new ArrayList<Professor>();
		for (Integer professorId : professorIds) {
			professors.add(this.getProfessor(professorId));
		}
		
		return professors;
	}
}
