package gui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import javax.swing.JTextField;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.awt.Dimension;
import javax.swing.JToolBar;
import java.awt.Panel;
import java.awt.GridBagLayout;
import javax.swing.JPasswordField;

public class LoginFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JTextField txtLogin = null;
	private JButton btnConfirm = null;
	private JLabel lblUser = null;
	private JLabel lblPassword = null;
	private JPasswordField pswField = null;
	/**
	 * This is the default constructor
	 */
	public LoginFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(408, 290);
		this.setContentPane(getJContentPane());
		this.setTitle("Tela Inicial");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			lblPassword = new JLabel();
			lblPassword.setBounds(new Rectangle(123, 113, 54, 23));
			lblPassword.setText("Senha:");
			lblUser = new JLabel();
			lblUser.setBounds(new Rectangle(123, 80, 54, 23));
			lblUser.setText("Login:");
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getTxtLogin(), null);
			jContentPane.add(getBtnConfirm(), null);
			jContentPane.add(lblUser, null);
			jContentPane.add(lblPassword, null);
			jContentPane.add(getPswField(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes txtLogin	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTxtLogin() {
		if (txtLogin == null) {
			txtLogin = new JTextField();
			txtLogin.setBounds(new Rectangle(186, 80, 99, 23));
		}
		return txtLogin;
	}

	/**
	 * This method initializes btnConfirm	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnConfirm() {
		if (btnConfirm == null) {
			btnConfirm = new JButton();
			btnConfirm.setBounds(new Rectangle(145, 147, 94, 19));
			btnConfirm.setText("Confirmar");
			btnConfirm.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent e) {
					MainGeneralProfessorFrame pFrame = new MainGeneralProfessorFrame();
					pFrame.setVisible(true);
				}
			});
		}
		return btnConfirm;
	}

	/**
	 * This method initializes pswField	
	 * 	
	 * @return javax.swing.JPasswordField	
	 */
	private JPasswordField getPswField() {
		if (pswField == null) {
			pswField = new JPasswordField();
			pswField.setBounds(new Rectangle(186, 113, 99, 23));
		}
		return pswField;
	}

}  //  @jve:decl-index=0:visual-constraint="10,-4"
