package gui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.Dimension;
import javax.swing.JTabbedPane;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.GridBagLayout;

import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class MainGeneralProfessorFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JTabbedPane tbdProfessor = null;
	private JPanel pnlGeneralData = null;
	private JLabel lblName = null;
	private JLabel lblEmail = null;
	private JList listOrienta = null;
	private JList listAvaliacao = null;
	private JButton btnConfirmGeneralData = null;
	private JButton btnCancelGeneralData = null;
	private JTextField txtName = null;
	private JTextField txtEmail = null;
	private JPanel pnlOriented = null;
	private JScrollPane jScrollPane = null;
	private JTable tblOriented = null;
	private JButton btnConfirmOriented = null;
	private JButton btlCancelOriented = null;
	private JPanel pnlAval = null;
	private JScrollPane jScrollPane1 = null;
	private JTable tblEvaluations = null;
	private JButton btnConfirmEvaluation = null;
	private JButton CancelEvaluation = null;
	private JLabel lblOriented = null;
	private JLabel lblEvaluation = null;
	/**
	 * This is the default constructor
	 */
	public MainGeneralProfessorFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(572, 447);
		this.setContentPane(getJContentPane());
		this.setTitle("Professor");
	}

	/**
	 * This method initializes jContentPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getTbdProfessor(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes tbdProfessor	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getTbdProfessor() {
		if (tbdProfessor == null) {
			tbdProfessor = new JTabbedPane();
			tbdProfessor.setBounds(new Rectangle(2, 8, 551, 398));
			tbdProfessor.addTab("Dados Gerais", null, getPnlGeneralData(), null);
			tbdProfessor.addTab("Orientaes", null, getPnlOriented(), null);
			tbdProfessor.addTab("Avaliaes", null, getPnlAval(), null);
		}
		return tbdProfessor;
	}

	/**
	 * This method initializes pnlGeneralData	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlGeneralData() {
		if (pnlGeneralData == null) {
			lblEvaluation = new JLabel();
			lblEvaluation.setBounds(new Rectangle(325, 109, 117, 26));
			lblEvaluation.setText("Alunos Avaliados:");
			lblOriented = new JLabel();
			lblOriented.setBounds(new Rectangle(104, 109, 117, 26));
			lblOriented.setText("Alunos Orientados:");
			lblEmail = new JLabel();
			lblEmail.setBounds(new Rectangle(8, 63, 39, 28));
			lblEmail.setText("Email:");
			lblName = new JLabel();
			lblName.setBounds(new Rectangle(8, 18, 39, 27));
			lblName.setText("Nome:");
			pnlGeneralData = new JPanel();
			pnlGeneralData.setLayout(null);
			pnlGeneralData.add(lblName, null);
			pnlGeneralData.add(lblEmail, null);
			pnlGeneralData.add(getListOrienta(), null);
			pnlGeneralData.add(getListAvaliacao(), null);
			pnlGeneralData.add(getBtnConfirmGeneralData(), null);
			pnlGeneralData.add(getBtnCancelGeneralData(), null);
			pnlGeneralData.add(getTxtName(), null);
			pnlGeneralData.add(getTxtEmail(), null);
			pnlGeneralData.add(lblOriented, null);
			pnlGeneralData.add(lblEvaluation, null);
		}
		return pnlGeneralData;
	}

	/**
	 * This method initializes listOrienta	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getListOrienta() {
		if (listOrienta == null) {
			listOrienta = new JList();
			listOrienta.setBounds(new Rectangle(97, 135, 127, 168));
		}
		
		insertingObjectInList(listOrienta, 1);
		return listOrienta;
	}
	
	private void insertingObjectInList(JList list, int temp){
		DefaultListModel model = new DefaultListModel();
		list.setModel(model);
		if(temp == 1)
			model.addElement("Aluno 1");
		else if(temp == 2)
			model.addElement("Aluno 2");
	}
	
	private void insertingColumns(JTable table){
		DefaultTableModel model = (DefaultTableModel)table.getModel();
		model.addColumn("Aluno");
		model.addColumn("Co-Orientador");
		model.addColumn("Titulo Monografia");
		model.addColumn("Monografia");
		model.addColumn("Nota Defesa");
		model.addColumn("Nota Apresentao");
		
		Object[] obj1 = new Object[4];
		obj1[0] = "Aluno 1";
		obj1[2] = "Ttulo";
		obj1[3] = "Monografia.pdf";
		model.addRow(obj1);
		
	}

	/**
	 * This method initializes listAvaliacao	
	 * 	
	 * @return javax.swing.JList	
	 */
	private JList getListAvaliacao() {
		if (listAvaliacao == null) {
			listAvaliacao = new JList();
			listAvaliacao.setBounds(new Rectangle(321, 135, 127, 168));
		}
		insertingObjectInList(listAvaliacao, 2);
		return listAvaliacao;
	}

	/**
	 * This method initializes btnConfirmGeneralData	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnConfirmGeneralData() {
		if (btnConfirmGeneralData == null) {
			btnConfirmGeneralData = new JButton();
			btnConfirmGeneralData.setBounds(new Rectangle(64, 321, 176, 31));
			btnConfirmGeneralData.setText("Confirmar Alteraes");
		}
		return btnConfirmGeneralData;
	}

	/**
	 * This method initializes btnCancelGeneralData	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnCancelGeneralData() {
		if (btnCancelGeneralData == null) {
			btnCancelGeneralData = new JButton();
			btnCancelGeneralData.setBounds(new Rectangle(304, 321, 176, 31));
			btnCancelGeneralData.setText("Cancelar Alteraes");
		}
		return btnCancelGeneralData;
	}

	/**
	 * This method initializes txtName	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTxtName() {
		if (txtName == null) {
			txtName = new JTextField();
			txtName.setBounds(new Rectangle(53, 21, 478, 25));
		}
		return txtName;
	}

	/**
	 * This method initializes txtEmail	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTxtEmail() {
		if (txtEmail == null) {
			txtEmail = new JTextField();
			txtEmail.setBounds(new Rectangle(53, 68, 478, 25));
		}
		return txtEmail;
	}

	/**
	 * This method initializes pnlOriented	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlOriented() {
		if (pnlOriented == null) {
			pnlOriented = new JPanel();
			pnlOriented.setLayout(null);
			pnlOriented.add(getJScrollPane(), null);
			pnlOriented.add(getBtnConfirmOriented(), null);
			pnlOriented.add(getBtlCancelOriented(), null);
		}
		return pnlOriented;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(3, 3, 540, 284));
			jScrollPane.setViewportView(getTblOriented());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes tblOriented	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getTblOriented() {
		if (tblOriented == null) {
			tblOriented = new JTable();
		}
		insertingColumns(tblOriented);	
		return tblOriented;
	}

	/**
	 * This method initializes btnConfirmOriented	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnConfirmOriented() {
		if (btnConfirmOriented == null) {
			btnConfirmOriented = new JButton();
			btnConfirmOriented.setBounds(new Rectangle(64, 321, 176, 31));
			btnConfirmOriented.setText("Confirmar Alteraes");
		}
		return btnConfirmOriented;
	}

	/**
	 * This method initializes btlCancelOriented	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtlCancelOriented() {
		if (btlCancelOriented == null) {
			btlCancelOriented = new JButton();
			btlCancelOriented.setBounds(new Rectangle(304, 321, 176, 31));
			btlCancelOriented.setText("Cancelar Alteraes");
		}
		return btlCancelOriented;
	}

	/**
	 * This method initializes pnlAval	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlAval() {
		if (pnlAval == null) {
			pnlAval = new JPanel();
			pnlAval.setLayout(null);
			pnlAval.add(getJScrollPane1(), null);
			pnlAval.add(getBtnConfirmEvaluation(), null);
			pnlAval.add(getCancelEvaluation(), null);
		}
		return pnlAval;
	}

	/**
	 * This method initializes jScrollPane1	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane1() {
		if (jScrollPane1 == null) {
			jScrollPane1 = new JScrollPane();
			jScrollPane1.setBounds(new Rectangle(3, 3, 540, 284));
			jScrollPane1.setViewportView(getTblEvaluations());
		}
		return jScrollPane1;
	}

	/**
	 * This method initializes tblEvaluations	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getTblEvaluations() {
		if (tblEvaluations == null) {
			tblEvaluations = new JTable();
		}
		
		insertingColumns(tblEvaluations);
		return tblEvaluations;
	}

	/**
	 * This method initializes btnConfirmEvaluation	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnConfirmEvaluation() {
		if (btnConfirmEvaluation == null) {
			btnConfirmEvaluation = new JButton();
			btnConfirmEvaluation.setBounds(new Rectangle(64, 321, 176, 31));
			btnConfirmEvaluation.setText("Confirmar Alteraes");
		}
		return btnConfirmEvaluation;
	}

	/**
	 * This method initializes CancelEvaluation	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getCancelEvaluation() {
		if (CancelEvaluation == null) {
			CancelEvaluation = new JButton();
			CancelEvaluation.setBounds(new Rectangle(304, 321, 176, 31));
			CancelEvaluation.setText("Cancelar Alteraes");
		}
		return CancelEvaluation;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
