package gui;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;
import java.awt.Dimension;
import javax.swing.JTabbedPane;
import java.awt.Rectangle;
import java.awt.GridBagLayout;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JRadioButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class MainProfessorFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JTabbedPane jTabbedPane = null;
	private JPanel pnlGeneral = null;
	private JPanel pnlResetPass = null;
	private JPanel pnlLoadLinks = null;
	private JLabel lblEmails = null;
	private JLabel lblTitle = null;
	private JTextField txtEmails = null;
	private JLabel lblUser = null;
	private JRadioButton rdbStudent = null;
	private JRadioButton rdbProfessor = null;
	private JButton btnAccept = null;
	private JButton btnCancek = null;
	private JScrollPane jScrollPane = null;
	private JTable tblStudents = null;
	private JButton btnConfirm = null;
	private JButton btlCancel = null;
	/**
	 * This is the default constructor
	 */
	public MainProfessorFrame() {
		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setSize(896, 400);
		this.setContentPane(getJContentPane());
		this.setTitle("Professor");
	}

	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(null);
			jContentPane.add(getJTabbedPane(), null);
		}
		return jContentPane;
	}

	/**
	 * This method initializes jTabbedPane	
	 * 	
	 * @return javax.swing.JTabbedPane	
	 */
	private JTabbedPane getJTabbedPane() {
		if (jTabbedPane == null) {
			jTabbedPane = new JTabbedPane();
			jTabbedPane.setBounds(new Rectangle(4, 2, 935, 424));
			jTabbedPane.addTab("Inserir Usuario", null, getPnlGeneral(), null);
			jTabbedPane.addTab("Planilha TCC", null, getPnlResetPass(), null);
		}
		return jTabbedPane;
	}

	/**
	 * This method initializes pnlGeneral	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlGeneral() {
		if (pnlGeneral == null) {
			lblUser = new JLabel();
			lblUser.setBounds(new Rectangle(13, 156, 485, 47));
			lblUser.setText("Insira o tipo de usurio a ser inserido, um tipo de cada vez.");
			lblTitle = new JLabel();
			lblTitle.setBounds(new Rectangle(13, 28, 485, 47));
			lblTitle.setText("Insira os emails dos usurios separados por ;");
			lblEmails = new JLabel();
			lblEmails.setBounds(new Rectangle(13, 81, 51, 25));
			lblEmails.setText("Emails:");
			pnlGeneral = new JPanel();
			pnlGeneral.setLayout(null);
			pnlGeneral.add(lblEmails, null);
			pnlGeneral.add(lblTitle, null);
			pnlGeneral.add(getTxtEmails(), null);
			pnlGeneral.add(lblUser, null);
			pnlGeneral.add(getRdbStudent(), null);
			pnlGeneral.add(getRdbProfessor(), null);
			pnlGeneral.add(getBtnAccept(), null);
			pnlGeneral.add(getBtnCancek(), null);
		}
		return pnlGeneral;
	}

	/**
	 * This method initializes pnlResetPass	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlResetPass() {
		if (pnlResetPass == null) {
			pnlResetPass = new JPanel();
			pnlResetPass.setLayout(null);
			pnlResetPass.add(getJScrollPane(), null);
			pnlResetPass.add(getBtnConfirm(), null);
			pnlResetPass.add(getBtlCancel(), null);
		}
		return pnlResetPass;
	}

	/**
	 * This method initializes pnlLoadLinks	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getPnlLoadLinks() {
		if (pnlLoadLinks == null) {
			pnlLoadLinks = new JPanel();
			pnlLoadLinks.setLayout(new GridBagLayout());
		}
		return pnlLoadLinks;
	}

	/**
	 * This method initializes txtEmails	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getTxtEmails() {
		if (txtEmails == null) {
			txtEmails = new JTextField();
			txtEmails.setBounds(new Rectangle(69, 81, 770, 25));
		}
		return txtEmails;
	}

	/**
	 * This method initializes rdbStudent	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getRdbStudent() {
		if (rdbStudent == null) {
			rdbStudent = new JRadioButton();
			rdbStudent.setBounds(new Rectangle(13, 203, 105, 39));
			rdbStudent.setText("Estudante");
		}
		return rdbStudent;
	}

	/**
	 * This method initializes rdbProfessor	
	 * 	
	 * @return javax.swing.JRadioButton	
	 */
	private JRadioButton getRdbProfessor() {
		if (rdbProfessor == null) {
			rdbProfessor = new JRadioButton();
			rdbProfessor.setBounds(new Rectangle(241, 203, 105, 39));
			rdbProfessor.setText("Professor");
		}
		return rdbProfessor;
	}

	/**
	 * This method initializes btnAccept	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnAccept() {
		if (btnAccept == null) {
			btnAccept = new JButton();
			btnAccept.setBounds(new Rectangle(88, 298, 156, 26));
			btnAccept.setText("Confirmar alteraes");
		}
		return btnAccept;
	}

	/**
	 * This method initializes btnCancek	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnCancek() {
		if (btnCancek == null) {
			btnCancek = new JButton();
			btnCancek.setBounds(new Rectangle(332, 298, 156, 26));
			btnCancek.setText("Cancelar Alteraes");
		}
		return btnCancek;
	}

	/**
	 * This method initializes jScrollPane	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	private JScrollPane getJScrollPane() {
		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setBounds(new Rectangle(6, 5, 832, 270));
			jScrollPane.setViewportView(getTblStudents());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes tblStudents	
	 * 	
	 * @return javax.swing.JTable	
	 */
	private JTable getTblStudents() {
		if (tblStudents == null) {
			tblStudents = new JTable();
		}
		insertingColumns(tblStudents);		
		return tblStudents;
	}
	
	private void insertingColumns(JTable table){
		DefaultTableModel model = (DefaultTableModel)table.getModel();
		model.addColumn("Aluno");
		model.addColumn("Orientador");
		model.addColumn("Co-Orientador");
		model.addColumn("Titulo Projeto");
		model.addColumn("Titulo Monografia");
		model.addColumn("Presidente da Banca");
		model.addColumn("Membro Externo");
		model.addColumn("Nota Defesa");
		model.addColumn("Concordncia de Orientao");
		model.addColumn("Projeto no Prazo");
		model.addColumn("Nota Final (SIGA)");
		
		Object[] obj1 = new Object[4];
		obj1[0] = "Aluno 1";
		obj1[1] = "Professor 1";
		obj1[3] = "Ttulo";
		model.addRow(obj1);
		
	}

	/**
	 * This method initializes btnConfirm	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtnConfirm() {
		if (btnConfirm == null) {
			btnConfirm = new JButton();
			btnConfirm.setBounds(new Rectangle(163, 302, 176, 26));
			btnConfirm.setText("Confirmar Alteraes");
		}
		return btnConfirm;
	}

	/**
	 * This method initializes btlCancel	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getBtlCancel() {
		if (btlCancel == null) {
			btlCancel = new JButton();
			btlCancel.setBounds(new Rectangle(502, 302, 176, 28));
			btlCancel.setText("Cancelar Alteraes");
		}
		return btlCancel;
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
