package service;

import java.util.ArrayList;
import data.Student;

public class RepositorioAluno {

	private ArrayList<Student> alunos;
	
	public RepositorioAluno(ArrayList<Student> arrayList){
		this.alunos = arrayList;
	}
	
	public int insertStudent(Student aluno){
		//Insere o professor no banco de dados.
		this.alunos.add(aluno);
		return aluno.getId();
	}
	
	public void removeStudent(int id){
		this.alunos.remove(alunos.get(id));
	}
	
	public Student getStudent(int id){
		return this.alunos.get(id);
	}
	
	public void updateStudent(Student s){
		Student oldStudent = this.alunos.get(s.getId());
		oldStudent.setEmail(s.getEmail());
		oldStudent.setName(s.getName());
		oldStudent.setCoOrientador(s.getCoOrientador());
		oldStudent.setMembroExterno(s.getMembroExterno());
		oldStudent.setOrientador(s.getOrientador());
		oldStudent.setPresidenteBanca(s.getPresidenteBanca());
		oldStudent.setProjeto(s.getProjeto());
		oldStudent.setConcordanciaOrientacao(s.isConcordanciaOrientacao());
		oldStudent.setNotaNoSiga(s.getNotaNoSiga());
	}
	
	public boolean existsStudent(int id){
		if(this.alunos != null && this.alunos.size() > 0){
			return this.alunos.contains(id);
		}
		else
			return false;
	}
}
