package service;

import java.util.ArrayList;

import data.Professor;

public class RepositorioProfessor {
	
	private ArrayList<Professor> professores;
	
	public RepositorioProfessor(ArrayList<Professor> professores){
		this.professores = professores;
	}
	
	public int insertProfessor(Professor professor){
		//Insere o professor no banco de dados.
		this.professores.add(professor);
		return professor.getId();
	}
	
	public void removeProfessor(int id){
		this.professores.remove(professores.get(id));
	}
	
	public Professor getProfessor(int id){
		return this.professores.get(id);
	}
	
	public void updateProfessor(Professor p){
		Professor profOld = this.professores.get(p.getId());
		profOld.setEmail(p.getEmail());
		profOld.setEstudantesBanca(p.getEstudantesBanca());
		profOld.setEstudantesOrientandos(p.getEstudantesOrientandos());
		profOld.setName(p.getName());
	}
	
	public boolean existsProfessor(int id){
		if(this.professores != null && this.professores.size() > 0){
			return this.professores.contains(id);
		}
		else
			return false;
	}
}
