package service;

import java.util.ArrayList;

import data.Project;

public class RepositorioProjeto {
	
	private ArrayList<Project> projetos;
	
	public RepositorioProjeto(ArrayList<Project> projetos){
		this.projetos = projetos;
	}
	
	public int insertProject(Project projeto){
		//Insere o projeto no banco de dados.
		this.projetos.add(projeto);
		return projeto.getId();
	}
	
	public void removeProject(int id){
		this.projetos.remove(projetos.get(id));
	}
	
	public Project getProject(int id){
		return this.projetos.get(id);
	}
	
	public void updateProject(Project p){
		Project oldProject = this.projetos.get(p.getId());
		oldProject.setMonografia(p.getMonografia());
		oldProject.setProjeto(p.getProjeto());
		oldProject.setTituloMonografia(p.getTituloMonografia());
		oldProject.setTituloProjeto(p.getTituloProjeto());
		oldProject.setNoPrazo(p.isNoPrazo());
		oldProject.setNotaDefesa(p.getNotaDefesa());
	}
	
	public boolean existsProject(int id){
		if(this.projetos != null && this.projetos.size() > 0){
			return this.projetos.contains(id);
		}
		else
			return false;
	}
}
